package de.bebagoe.tableviewproper;

import javafx.beans.property.*;
import java.time.LocalDate;

public class Person {
	private ReadOnlyObjectWrapper<LocalDate> creationDate;
	private StringProperty firstName;
	private StringProperty lastName;
	private ObjectProperty<LocalDate> birthday;

	public Person(String first, String last, String bday) {
		creationDate = new ReadOnlyObjectWrapper<LocalDate>(LocalDate.now());
		firstName = new SimpleStringProperty(first);
		lastName = new SimpleStringProperty(last);
		birthday = new SimpleObjectProperty<LocalDate>(LocalDate.parse(bday));
	}

	public final LocalDate getCreationDate() { return creationDate.get(); }
	public final ReadOnlyObjectProperty<LocalDate> creationDateProperty() {
		return creationDate.getReadOnlyProperty();
	}

	public final String getFirstName() { return firstName.get(); }
	public final void setFirstName(String first) { firstName.set(first); }
	public final StringProperty firstNameProperty() { return firstName;	}

	public final String getLastName() {	return lastName.get();	}
	public final void setLastName(String last) { lastName.set(last); }
	public final StringProperty lastNameProperty() { return lastName; }

	public final void setBirthday(LocalDate date) {	birthday.set(date);	}
	public final LocalDate getBirthday() { return birthday.get(); }
	public final ObjectProperty<LocalDate> birthdayProperty() { return birthday; }
}